FK =
{
	numBuiltHouses = 0,
	numBuiltFarms = 0,

	sawMillBuilt = false,
	waterMillBuilt = false,
	quarryBuilt = false,
	tavernBuilt = false,
	windMillBuilt = false,
	goldMineBuilt = false,
	specialBuilt = false,
	wortexBuilt = false,
	palaceP01Built = false,
	palaceP02Built = false,
	palaceP03Built = false,
	palaceP04Built = false,
	palaceP05Built = false,

	-- build menu: unlock building types
	sawMillUnlocked = false,
	farmsUnlocked = false,
	waterMillUnlocked = false,
	quarryUnlocked = false,
	tavernUnlocked = false,
	windMillUnlocked = false,
	goldMineUnlocked = false,
	specialUnlocked = false,
	wortexUnlocked = false,
	palaceUnlocked = false,

-- PIRATES: 01(viking), 02(chinese), 03(african), 04(turkish), 05(european)
	piratesEnabled = false,
	pirateNum = 1,							-- Five diff. pirates: 1,2,3,4,5.
	pirateDelayStartTime = 0,			-- Time when the pirate delay starts.
												-- Akkor kapja az aktulis idt amikor a haj megllt.
	pirateDelay = 20,						-- Current delay between 2 pirate attacks. It must be more then 10 sec or may bug!
												-- Az elz haj megllstl ennyi ksleltets van a kv. haj create eltt.
	pirateMinDelay = 330,				-- Constant. Random delay is added to this.
	pirateRandomTimeRange = 30,		-- Random delay.
	pirateReady = false,					-- True = Delay is over, next pireate can come.
	resourceAsked = "_",					-- Demanded resource. (meal, wood, stone, flour, gold)
	amountAsked = 125,					-- Current demanded quantity.
	demandPortion = 0.05,				-- portion of the player's resource what the pirate demans
	gotPiratedBuilding = false,
	playerIsRich = false,
	airFree = true,
	SsaverOn = false,

-- MERCHANTS: 01(european), 02(african), 03(chinese), 04(viking), 05(turkish)
	merchantsEnabled = false,
	merchantNum = 1,						-- Five diff. merchants: 1,2,3,4,5.
	merchantDelayStartTime = 0,		-- Time when timer starts.
												-- Akkor kapja az aktulis idt amikor a haj megllt.
	merchantDelay = 40,					-- Current delay between 2 merchant ships. It must be more then 10 sec or may bug!
												-- Az elz haj megllstl ennyi ksleltets van a kv. haj create eltt.
	merchantMinDelay = 180,				-- Constant. Random delay is added to this.
	merchantRandomTimeRange = 30,		-- Random delay.
	merchantReady = false,				-- Delay is over, next merchant can come.

-- LEVEL SPECIFIC VARIABLES
	activeObj = 0.0,    					-- current objective number
	completedObj = 0.0,					-- last completed objective number
	firstSSon = true,
	firstSSoff = true,
	firstDiaryMailtabOn = true,
	firstDiaryNotetabOn = true,
	firstDiaryOff = true,
	objHideWasAt = 0,

	farm1stEnter = true,
	sawmill1stEnter = true,
	quarry1stEnter = true,
	watermill1stEnter = true,
	windmill1stEnter = true,
	tavern1stEnter = true,
	goldmine1stEnter = true,

	mailTextNumber = 0,
	mail02sent = false
}


function OnEverySecond()

	if (event.Time == 0) then
		_ShowGUI(false)				-- player has no control yet

--		_StartCutscene("cutscene_04", 1, 6)					-- dev
		_StartCutscene("cutscene_04", 10, 6)					-- level starting cutscene

		_SetVariableBool("House01Enabled", true)			-- initial building unlocks
		_SetVariableBool("House02Enabled", true)
		_SetVariableBool("House03Enabled", true)
		_SetVariableBool("House04Enabled", true)

		_Build("House03", 100)
		_Build("House04", 100)

		_Build("SawMill", 100)

--[[ tesztels gyorstshoz
		_Build("House01", 100)
		_Build("House02", 100)
		_Build("House03", 100)
		_Build("House04", 100)
		_Build("SawMill", 100)
		_Build("StoneMine", 100)
		_Build("Farm01", 100)
		_Build("Farm02", 100)
		_Build("Farm03", 100)
		_Build("Farm04", 100)
		_Build("WaterMill", 100)
		_Build("Tavern", 100)
		_Build("WindMill", 100)
		_Build("GoldMine", 100)
--]]

		_SetVariableBool("ShowObjectiveText", true)		-- 1 line onscreen objectives display on.
	end

			--=======--
	---=== Building unlocks ===---
	if (FK.sawMillUnlocked == false and 1 < FK.numBuiltHouses) then			-- sawmill, quarry unlocking
		FK.sawMillUnlocked = true
		_SetVariableBool("SawMillEnabled", true)

		FK.quarryUnlocked = true
		_SetVariableBool("StoneMineEnabled", true)

		FK.goldMineUnlocked = true
		_SetVariableBool("GoldMineEnabled", true)
	end

	if (FK.farmsUnlocked == false and FK.sawMillBuilt and FK.quarryBuilt and FK.goldMineBuilt) then		-- farm, watermill unlocking
		FK.farmsUnlocked = true
		_SetVariableBool("Farm01Enabled", true)
		_SetVariableBool("Farm02Enabled", true)
		_SetVariableBool("Farm03Enabled", true)
		_SetVariableBool("Farm04Enabled", true)
		FK.waterMillUnlocked = true
		_SetVariableBool("WaterMillEnabled", true)
	end

	if (FK.tavernUnlocked == false and FK.waterMillBuilt and 0 < FK.numBuiltFarms) then		-- tavern, windmill unlocking
		FK.tavernUnlocked = true
		_SetVariableBool("TavernEnabled", true)
		FK.windMillUnlocked = true
		_SetVariableBool("WindMillEnabled", true)

		FK.merchantsEnabled = true								-- merchants can turn up from now on
	end

	if (FK.palaceUnlocked == false and FK.windMillBuilt and FK.tavernBuilt and FK.numBuiltFarms == 4) then
		_SetVariableBool("PalaceEnabled", true)
		FK.palaceUnlocked = true
	end


			--=======--
	---=== PIRATES ===---
	DefinePirateDemand()

	if (FK.amountAsked < 5) then
		FK.playerIsRich = false
	else
		FK.playerIsRich = true
	end

	if (_IsAnyPiratedBuilding()) then
		FK.gotPiratedBuilding = true
	elseif (FK.gotPiratedBuilding) then							-- if pirate curse just got removed
		FK.pirateDelayStartTime = event.Time					-- then pirate delay resets
		FK.gotPiratedBuilding = false
	end

	if (FK.piratesEnabled and not FK.gotPiratedBuilding and not FK.SsaverOn and FK.playerIsRich and FK.pirateDelayStartTime + FK.pirateDelay < event.Time) then
		FK.piratesEnabled = false
		FK.pirateReady = true
	end

	if (FK.pirateReady and FK.airFree and event.GameState == "MainGame" ) then
		FK.pirateReady = false
		FK.airFree = false
		FK.pirateNum = math.random(5)
		_CreatePirate("Pir0" .. FK.pirateNum, "msg_pirate0" .. FK.pirateNum, FK.pirateNum, FK.resourceAsked, FK.amountAsked)
		FK.pirateDelay = FK.pirateMinDelay + math.random(FK.pirateRandomTimeRange)
		_Log("Pirate created at: " .. event.Time .. ". Delay was: " .. FK.pirateDelay)
	end

			--=======--
	---=== MERCHANTS ===---
	if (FK.merchantsEnabled and not FK.SsaverOn and FK.merchantDelayStartTime + FK.merchantDelay < event.Time) then
		FK.merchantsEnabled = false
		FK.merchantReady = true
	end

	if (FK.merchantReady and FK.airFree and event.GameState == "MainGame") then
		FK.merchantReady = false
		FK.airFree = false
		FK.merchantNum = math.random(5)
		_CreateMerchant("Merch0"..FK.merchantNum, "msg_merchant0"..FK.merchantNum, FK.merchantNum)
		FK.merchantDelay = FK.merchantMinDelay + math.random(FK.merchantRandomTimeRange)
		_Log("Merchant created at: " .. event.Time .. ". Delay was: " .. FK.merchantDelay)
	end

	--- lvl 4 stuff (on ever sec)

	-- mail 2
	if (event.GameState == "MainGame" and FK.tavernUnlocked and not FK.SsaverOn and not FK.mail02sent) then
		FK.mail02sent = true
		_SendMail(2)
		FK.mailTextNumber = math.random(6)
		_ShowDialog("Mail02", "mail_arrived0" .. FK.mailTextNumber, "Cornelia", "Ok")
	end
end


-- lvl 4 spec
function OnCutsceneEnded_cutscene_04()
	_StartIntro()		-- imp ship in, npcs descend
end

function OnIntroEnded()
	_ShowGUI(true)					-- player gets control

	_EnableButton("DiaryButton", false)				-- Diary menu disabled.
	_EnableButton("ScreenSaverButton", false)		-- Pause/screensave menu disabled.
	_EnableButton("BuildButton", false)

	_ShowDialog("Dialog01", "m04_msg01", "Sancho", "Ok")
end

function OnDialogClosed_Dialog01()
	_ShowDialog("Dialog02", "m04_msg02", "Sancho", "Ok")
end

function OnDialogClosed_Dialog02()
	_ShowDialog("Dialog03", "m04_msg03", "Sancho", "Ok")
end

function OnDialogClosed_Dialog03()
	_EnableButton("ScreenSaverButton", true)		-- Pause/screensave menu disabled.
	_Blink("ScreenSaverButton", true)

	_ShowObjective("m04_obj01")
	FK.activeObj = 1
end

function OnScreenSaverActivated()
	FK.SsaverOn = true

	if (FK.firstSSon) then
		FK.firstSSon = false
		_Blink("ScreenSaverButton", false)
		_CompleteObjective("m04_obj01")
		FK.completedObj = 1
		_ShowObjective("m04_obj02")
		FK.activeObj = 2
	end
end

function OnScreenSaverDeactivated()
	FK.pirateDelayStartTime = event.Time
	FK.merchantDelayStartTime = event.Time
	FK.SsaverOn = false


	if (FK.firstSSoff) then
		FK.firstSSoff = false
		_CompleteObjective("m04_obj02")
		FK.completedObj = 2
		_ShowDialog("Dialog04", "m04_msg04", "Sancho", "Ok")
	end
end

function OnDialogClosed_Dialog04()
	_ShowDialog("Dialog05", "m04_msg05", "Cornelia", "Ok")
end

function OnDialogClosed_Dialog05()
	_EnableButton("DiaryButton", true)				-- Diary menu disabled.
	_SendMail(1)
	_SetActiveDiaryPage("Mails")

	_ShowObjective("m04_obj03")						-- "Click on the flashing icon to open the Diary!"
	FK.activeObj = 3
end

-------===========================
function OnDiaryOpenedAtMails()			-- diary mail tab (game paused while diary is open)
	if (FK.activeObj == 3 and FK.completedObj == 2) then
		_SetVariableBool("ShowObjectiveText", false)
		_CompleteObjective("m04_obj03")
		FK.completedObj = 3

		_ShowObjective("m04_obj04")						-- "turn the page with the highlighted button!"
		FK.activeObj = 4

		_StartParticle("global_warning", 470, 580)					-- effect on notes tab
		_ShowDialog("Dialog06", "m04_msg06", "Cornelia", "Ok")
		_Blink("DiaryButton", true)
	end

	if (FK.activeObj == 4 and FK.completedObj == 3) then
		_StartParticle("global_warning", 470, 580)						-- notes tab
		_Blink("DiaryButton", true)
	end
end

function OnDiaryOpenedAtNotes()
	if (FK.activeObj == 4 and FK.completedObj == 3) then
		_Blink("DiaryButton", false)
		FK.completedObj = 3.5

		_StopParticle()
		_ShowDialog("Dialog07", "m04_msg07", "Cornelia", "Ok")
	end
end

function OnDialogClosed_Dialog07()
	_ShowDialog("Dialog08", "m04_msg08", "Cornelia", "Ok")
end

function OnDialogClosed_Dialog08()
end

function OnDiaryClosed()
	if (FK.activeObj == 4 and FK.completedObj == 3) then
		_StopParticle()
	end

	if (FK.activeObj == 4 and FK.completedObj == 3.5) then
		_SetVariableBool("ShowObjectiveText", true)
		_CompleteObjective("m04_obj04")
		FK.completedObj = 4

		_ShowDialog("Dialog09", "m04_msg09", "Sancho", "Ok")
	end
end

function OnDialogClosed_Dialog09()
	_ShowDialog("Dialog10", "m04_msg10", "Sancho", "Ok")
end

function OnDialogClosed_Dialog10()
	_EnableButton("BuildButton", true)
	_ShowObjective("m04_obj05")
	FK.activeObj = 5
	_CreateTimer("objHideTimer", 0, 10)
end

function OnTimerEnded_objHideTimer()
	_SetVariableBool("ShowObjectiveText", false)		-- 1 line onscreen objectives display off for some time
	FK.objHideWasAt = event.Time
end
-------===========================

function OnMiniGameEnter_Farm()
	if (FK.farm1stEnter) then
		FK.farm1stEnter = false
		_ShowMiniGameDialog("DialogMini01", "m04_mini01", "Sancho", "Ok")
	end
end

function OnMiniGameEnter_SawMill()
	if (FK.sawmill1stEnter) then
		FK.sawmill1stEnter = false
		_ShowMiniGameDialog("DialogMini02", "m04_mini02", "Sancho", "Ok")
	end
end

function OnMiniGameEnter_StoneMine()
	if (FK.quarry1stEnter) then
		FK.quarry1stEnter = false
		_ShowMiniGameDialog("DialogMini03", "m04_mini03", "Sancho", "Ok")
	end
end

function OnMiniGameEnter_WaterMill()
	if (FK.watermill1stEnter) then
		FK.watermill1stEnter = false
		_ShowMiniGameDialog("DialogMini04", "m04_mini04", "Sancho", "Ok")
	end
end

function OnMiniGameEnter_WindMill()
	if (FK.windmill1stEnter) then
		FK.windmill1stEnter = false
		_ShowMiniGameDialog("DialogMini05", "m04_mini05", "Sancho", "Ok")
	end
end

function OnMiniGameEnter_Tavern()
	if (FK.tavern1stEnter) then
		FK.tavern1stEnter = false
-- konfliktol a nincs hes ember dialggal!
--		_ShowMiniGameDialog("DialogMini06", "m04_mini06", "Sancho", "Ok")
	end
end

function OnMiniGameEnter_GoldMine()
	if (FK.goldmine1stEnter) then
		FK.goldmine1stEnter = false
		_ShowMiniGameDialog("DialogMini07", "m04_mini07", "Sancho", "Ok")
	end
end

function OnBuildingStarted_Palace()
	_CompleteObjective("m04_obj05")
	FK.completedObj = 5

	_Blink("BuildButton", false)
	_EnableButton("GemButton", false)
	_EnableButton("DiaryButton", false)
	_EnableButton("ScreenSaverButton", false)
	_EnableButton("BuildButton", false)

	_SetVariableBool("ShowObjectiveText", true)		-- 1 line onscreen objectives display on.
	_ShowObjective("msg_obj_last")
	_ShowGUI(false)
end

			--=======--
	---=== PIRATES ===---
function DefinePirateDemand()
	if (event.Meal < event.Wood) then					-- Resourses system variables: event.Meal, event.Wood, event.Stone, event.Flour, event.Gold
		if (event.Wood < event.Stone) then
			if (event.Stone < event.Flour) then
				if (event.Flour < event.Gold) then
					FK.resourceAsked = "Gold"
					FK.amountAsked = event.Gold * FK.demandPortion
				else
					FK.resourceAsked = "Flour"
					FK.amountAsked = event.Flour * FK.demandPortion
				end
			else
				if (event.Stone < event.Gold) then
					FK.resourceAsked = "Gold"
					FK.amountAsked = event.Gold * FK.demandPortion
				else
					FK.resourceAsked = "Stone"
					FK.amountAsked = event.Stone * FK.demandPortion
				end
			end
		else
			if (event.Wood < event.Flour) then
				if (event.Flour < event.Gold) then
					FK.resourceAsked = "Gold"
					FK.amountAsked = event.Gold * FK.demandPortion
				else
					FK.resourceAsked = "Flour"
					FK.amountAsked = event.Flour * FK.demandPortion
				end
			else
				if (event.Wood < event.Gold) then
					FK.resourceAsked = "Gold"
					FK.amountAsked = event.Gold * FK.demandPortion
				else
					FK.resourceAsked = "Wood"
					FK.amountAsked = event.Wood * FK.demandPortion
				end
			end
		end
	else
		if (event.Meal < event.Stone) then
			if (event.Stone < event.Flour) then
				if (event.Flour < event.Gold) then
					FK.resourceAsked = "Gold"
					FK.amountAsked = event.Gold * FK.demandPortion
				else
					FK.resourceAsked = "Flour"
					FK.amountAsked = event.Flour * FK.demandPortion
				end
			else
				if (event.Stone < event.Gold) then
					FK.resourceAsked = "Gold"
					FK.amountAsked = event.Gold * FK.demandPortion
				else
					FK.resourceAsked = "Stone"
					FK.amountAsked = event.Stone * FK.demandPortion
				end
			end
		else
			if (event.Meal < event.Flour) then
				if (event.Flour < event.Gold) then
					FK.resourceAsked = "Gold"
					FK.amountAsked = event.Gold * FK.demandPortion
				else
					FK.resourceAsked = "Flour"
					FK.amountAsked = event.Flour * FK.demandPortion
				end
			else
				if (event.Meal < event.Gold) then
					FK.resourceAsked = "Gold"
					FK.amountAsked = event.Gold * FK.demandPortion
				else
					FK.resourceAsked = "Meal"
					FK.amountAsked = event.Meal * FK.demandPortion
				end
			end
		end
	end
end

-- PIRATE 01
function OnShipReachedPosition_Pir01()
	DefinePirateDemand()
	_PirateInfoRefresh(FK.resourceAsked, FK.amountAsked)
	FK.pirateDelayStartTime = event.Time
	FK.piratesEnabled = true
	FK.airFree = true
end

function OnDialogClosed_Pir01()
	_ModifyResource(FK.resourceAsked, -FK.amountAsked)
end

function OnDialogClosed2ndButton_Pir01()
	_PirateBuilding()
end

-- PIRATE 02
function OnShipReachedPosition_Pir02()
	DefinePirateDemand()
	_PirateInfoRefresh(FK.resourceAsked, FK.amountAsked)
	FK.pirateDelayStartTime = event.Time
	FK.piratesEnabled = true
	FK.airFree = true
end

function OnDialogClosed_Pir02()
	_ModifyResource(FK.resourceAsked, -FK.amountAsked)
end

function OnDialogClosed2ndButton_Pir02()
	_PirateBuilding()
end

-- PIRATE 03
function OnShipReachedPosition_Pir03()
	DefinePirateDemand()
	_PirateInfoRefresh(FK.resourceAsked, FK.amountAsked)
	FK.pirateDelayStartTime = event.Time
	FK.piratesEnabled = true
	FK.airFree = true
end

function OnDialogClosed_Pir03()
	_ModifyResource(FK.resourceAsked, -FK.amountAsked)
end

function OnDialogClosed2ndButton_Pir03()
	_PirateBuilding()
end

-- PIRATE 04
function OnShipReachedPosition_Pir04()
	DefinePirateDemand()
	_PirateInfoRefresh(FK.resourceAsked, FK.amountAsked)
	FK.pirateDelayStartTime = event.Time
	FK.piratesEnabled = true
	FK.airFree = true
end

function OnDialogClosed_Pir04()
	_ModifyResource(FK.resourceAsked, -FK.amountAsked)
end

function OnDialogClosed2ndButton_Pir04()
	_PirateBuilding()
end

-- PIRATE 05
function OnShipReachedPosition_Pir05()
	DefinePirateDemand()
	_PirateInfoRefresh(FK.resourceAsked, FK.amountAsked)
	FK.pirateDelayStartTime = event.Time
	FK.piratesEnabled = true
	FK.airFree = true
end

function OnDialogClosed_Pir05()
	_ModifyResource(FK.resourceAsked, -FK.amountAsked)
end

function OnDialogClosed2ndButton_Pir05()
	_PirateBuilding()
end

			--=======--
	---=== MERCHANTS ===---
function OnShipReachedPosition_Merch01()
	FK.merchantDelayStartTime = event.Time
	FK.merchantsEnabled = true
	FK.airFree = true
end

function OnShipReachedPosition_Merch02()
	FK.merchantDelayStartTime = event.Time
	FK.merchantsEnabled = true
	FK.airFree = true
end

function OnShipReachedPosition_Merch03()
	FK.merchantDelayStartTime = event.Time
	FK.merchantsEnabled = true
	FK.airFree = true
end

function OnShipReachedPosition_Merch04()
	FK.merchantDelayStartTime = event.Time
	FK.merchantsEnabled = true
	FK.airFree = true
end

function OnShipReachedPosition_Merch05()
	FK.merchantDelayStartTime = event.Time
	FK.merchantsEnabled = true
	FK.airFree = true
end

			--=======--
	---=== HOUSES FINISHED ===---
function OnBuildingCompleted_House01()
	FK.numBuiltHouses = FK.numBuiltHouses + 1
end

function OnBuildingCompleted_House02()
	FK.numBuiltHouses = FK.numBuiltHouses + 1
end

function OnBuildingCompleted_House03()
	FK.numBuiltHouses = FK.numBuiltHouses + 1
end

function OnBuildingCompleted_House04()
	FK.numBuiltHouses = FK.numBuiltHouses + 1
end

			--=======--
	---=== FARMS FINISHED ===---
function OnBuildingCompleted_Farm01()
	FK.numBuiltFarms = FK.numBuiltFarms + 1
end

function OnBuildingCompleted_Farm02()
	FK.numBuiltFarms = FK.numBuiltFarms + 1
end

function OnBuildingCompleted_Farm03()
	FK.numBuiltFarms = FK.numBuiltFarms + 1
end

function OnBuildingCompleted_Farm04()
	FK.numBuiltFarms = FK.numBuiltFarms + 1
end

			--=======--
	---=== OTHER BUILDINGS FINISHED ===---
function OnBuildingCompleted_SawMill()
	FK.sawMillBuilt = true
end

function OnBuildingCompleted_WaterMill()
	FK.waterMillBuilt = true
end

function OnBuildingCompleted_StoneMine()
	FK.quarryBuilt = true
end

function OnBuildingCompleted_Tavern()
	FK.tavernBuilt = true

	if (FK.windMillBuilt) then
		FK.piratesEnabled = true								-- pirates can turn up from now on
	end
end

function OnBuildingCompleted_WindMill()
	FK.windMillBuilt = true

	if (FK.tavernBuilt) then
		FK.piratesEnabled = true								-- pirates can turn up from now on
	end
end

function OnBuildingCompleted_GoldMine()
	FK.goldMineBuilt = true
end

			--=======--
	---=== PALACE PHASES FINISHED ===---
function OnBuildingCompleted_PalacePhase01()
	FK.palaceP01Built = true
end

function OnBuildingCompleted_PalacePhase02()
	FK.palaceP02Built = true
end

function OnBuildingCompleted_PalacePhase03()
	FK.palaceP03Built = true
end

function OnBuildingCompleted_PalacePhase04()
	FK.palaceP04Built = true
end

function OnBuildingCompleted_PalacePhase05()
	FK.palaceP05Built = true
	_CompleteObjective("msg_obj_last")
	MissionComplete()
end

function OnCtrlE()
	MissionComplete()
end

function OnCtrlR()
	_ModifyResource("Wood", 500)
	_ModifyResource("Stone", 500)
	_ModifyResource("Gold", 500)

	_ModifyResource("Meal", 500)
	_ModifyResource("Flour", 500)
end

			--=======--
	---=== Mission complete ===---
function MissionComplete()
	_ShowGUI(false)
	_StartOutro()
end

function OnOutroEnded()
	_ShowDialog("Dialog_miss_comp", "mission_completed", "Aurelius", "Ok")
end

function OnDialogClosed_Dialog_miss_comp()
	_EndMission()
end
